<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable, Followable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    
    protected $guarded = ['id'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    //Post belongs to user
    public function posts()
    {
        return $this->hasMany(Post::class);
    }

    //Comments belongs to user
    public function comments()
    {
        return $this->hasMany(Comment::class);
    }
    
    //posts that a specific user has liked
    public function likedPosts()
    {
        return $this->morphedByMany('App\Models\Post', 'likeable')->whereDeletedAt(null);
    }

}
