@extends('layouts.master')
@section('bodyclass')
    <body>
@endsection
@section('jumbotron')
<div class="jumbotron bg-none">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-12">
                <h1 class="display-4">@lang('messages.sign.title')</h1>
            </div>
        </div>
    </div>
</div>
@endsection

@section('content')
<div class="container pt-5 pb-4">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <form class="form-horizontal" role="form" method="POST" action="{{ route('register') }}">
                @csrf

                <div class="mb-3{{ $errors->has('name') ? ' has-error' : '' }}">
                    <label for="name" class="col-md-4 form-label">@lang('messages.sign.name')</label>

                    <div class="col-md-6">
                        <input id="name" type="text" class="form-control" name="name" value="{{ old('name') }}" required autofocus>

                        @if ($errors->has('name'))
                        <span class="help-block">
                            <strong>{{ $errors->first('name') }}</strong>
                        </span>
                        @endif
                    </div>
                </div>

                <div class="mb-3{{ $errors->has('username') ? ' has-error' : '' }}">
                    <label for="name" class="col-md-4 form-label">@lang('messages.sign.username')</label>

                    <div class="col-md-6">
                        <input id="username" type="text" class="form-control" name="username" value="{{ old('username') }}" required autofocus>

                        @if ($errors->has('username'))
                        <span class="help-block">
                            <strong>{{ $errors->first('username') }}</strong>
                        </span>
                        @endif
                    </div>
                </div>

                <div class="mb-3{{ $errors->has('email') ? ' has-error' : '' }}">
                    <label for="email" class="col-md-4 form-label">@lang('messages.sign.email')</label>

                    <div class="col-md-6">
                        <input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}" required>

                        @if ($errors->has('email'))
                        <span class="help-block">
                            <strong>{{ $errors->first('email') }}</strong>
                        </span>
                        @endif
                    </div>
                </div>

                <div class="mb-3{{ $errors->has('password') ? ' has-error' : '' }}">
                    <label for="password" class="col-md-4 form-label">@lang('messages.sign.password')</label>

                    <div class="col-md-6">
                        <input id="password" type="password" class="form-control" name="password" required>

                        @if ($errors->has('password'))
                        <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                        @endif
                    </div>
                </div>

                <div class="mb-3">
                    <label for="password-confirm" class="col-md-4 form-label">@lang('messages.sign.cpassword')</label>

                    <div class="col-md-6">
                        <input id="password_confirmation" type="password" class="form-control" name="password_confirmation" required>
                    </div>
                </div>

                <div class="mb-3">
                    <div class="col-md-6 col-md-offset-4">
                        <button type="submit" class="btn btn-primary btnpoint">
                            @lang('messages.sign.register')
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
